const express = require('express');
const router = express.Router();
const pool = require('../db');

router.post('/topup', async (req, res) => {
    const { amount, user_id } = req.body;
    if (amount <= 0 || !user_id) {
        return res.status(400).send('Amount must be positive and user_id is required');
    }

    try {
        const [user] = await pool.query('SELECT username FROM users WHERE id = ?', [user_id]);
        if (user.length === 0) {
            return res.status(404).send('User  not found');
        }

        await pool.query('UPDATE users SET coins = coins + ? WHERE id = ?', [amount, user_id]);
        res.status(200).json({
            status: 'success',
            message: `Top-up successful, added ${amount} coins`,
            user: {
                user_id,
                username: user[0].username
            }
        });
    } catch (error) {
        res.status(500).send('Database error');
    }
});

module.exports = router;
